# do separate baseline analyses in one

expandpars<-function(parsT,parsR,w)
{
nc<-ncol(w)
f1<-f2<-rep(0,nc)
for(i in 1:nc) if(w[1,i]!=0) f1[i]<-as.vector(parsT[[1,'phi']])[w[1,i]]
for(i in 1:nc) if(w[2,i]!=0) f2[i]<-as.vector(parsR[[1,'phi']])[w[2,i]]
mixpar(
	rho=list(parsT[[1,'rho']],parsR[[1,'rho']]),
	eta = list(parsT[[1,'eta']],parsR[[1,'eta']]),
	xi = list(parsT[[1,'xi']],parsR[[1,'xi']]),
	phi = list(
	  structure(f1,names=paste0('U',1:nc)),
	  structure(f2,names=paste0('U',1:nc))
	))
}

baseline<-baselineT+baselineR

cat('... baseline:',baseline,'\n')

###########

# mixture model with same 2 contributors to each trace

pars2<-expandpars(parsT,parsR,rbind(c(1,2),c(1,2)))
print(pars2)

mix1eq<-DNAmixture(list(epgT,epgR),k=2, C = rep(list(C), 2), database=db)
cat('... log10LR for same 2 contribs:',(logL(mix1eq)(pars2)-baseline)/log(10),'\n')

# mixture model with same 2 contribs, U1=parent of D
mixDeq<-DNAmixture(list(epgT,epgR),k=2, C = rep(list(C), 2), database=db,
                     compile=FALSE,triangulate=FALSE)
rpt.IBD(mixDeq,IBD='parent-child',typed.gts=list(D=Dgt),
	targets=c('U1','D'),contribs=c('U1','U2'),quiet=TRUE)

cat('... log10LR for same 2 contribs, U1=parent of D:',(logL(mixDeq)(pars2)-baseline)/log(10),'\n')

###########

# mixture model with same U1, indpt other contrib

pars3a<-expandpars(parsT,parsR,rbind(c(1,2,0),c(1,0,2)))
print(pars3a)

mix1eq<-DNAmixture(list(epgT,epgR),k=3, C = rep(list(C), 2), database=db)

cat('... log10LR for U1=U2, indpt U3:',(logL(mix1eq)(pars3a)-baseline)/log(10),'\n')

mix1eq<-DNAmixture(list(epgT,epgR),k=3, C = rep(list(C), 2), database=db,
                   compile=FALSE,triangulate=FALSE)
rpt.IBD(mix1eq,'parent',typed=list(D=Dgt),targets=c('U1','D'),contribs=c('U1','U2','U3'),quiet=TRUE)

cat('... log10LR for U1=U2=parent of D, indpt U3:',(logL(mix1eq)(pars3a)-baseline)/log(10),'\n')

###########

# mixture model with T = F&M of D, RB = F of D and unknown

print(pars3a)

mixDeq<-DNAmixture(list(epgT,epgR),k=3, C = rep(list(C), 2), database=db,
                     compile=FALSE,triangulate=FALSE)
rpt.IBD(mixDeq,IBD=list(patt=c(1,2,3,4,1,3)),typed.gts=list(D=Dgt),
	targets=c('U1','U2','D'),contribs=c('U1','U2','U3'),quiet=TRUE)

cat('... log10LR for T = F&M of D, RB = F of D and unknown:',(logL(mixDeq)(pars3a)-baseline)/log(10),'\n')

# mixture model with T = M&F of D, RB = F of D and unknown

pars3b<-expandpars(parsT,parsR,rbind(c(1,2,0),c(0,1,2)))
print(pars3b)

mixDeq<-DNAmixture(list(epgT,epgR),k=3, C = rep(list(C), 2), database=db,
                     compile=FALSE,triangulate=FALSE)
rpt.IBD(mixDeq,IBD=list(patt=c(1,2,3,4,1,3)),typed.gts=list(D=Dgt),
	targets=c('U1','U2','D'),contribs=c('U1','U2','U3'),quiet=TRUE)

cat('... log10LR for T = M&F of D, RB = F of D and unknown:',(logL(mixDeq)(pars3b)-baseline)/log(10),'\n')

